@extends('layouts.layout')

@section('content')
<div class="content-wrapper">
    <!-- Page Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h1 class="m-0 text-dark">License Information</h1>
                </div>
                <div class="col-md-6">
                    <ol class="breadcrumb float-md-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}" class="text-primary">Home</a></li>
                        <li class="breadcrumb-item active">License Status</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- Main Content -->
    <section class="content">
        @include('notify.errors')
        @include('notify.success')

        <div class="container-fluid">
            <div class="row">
                <!-- License Details -->
                <div class="col-lg-6 mb-4">
                    <div class="card border-info shadow">
                        <div class="card-header bg-success text-white">
                            <h3 class="card-title"><i class="fas fa-info-circle"></i> License Details</h3>
                        </div>
                        <div class="card-body">
                            <ul class="list-group list-group-flush">
                                @foreach ($licenseDataArray as $key => $value)
                                <li class="list-group-item">
                                    <strong>{{ ucfirst(str_replace('_', ' ', $key)) }}:</strong> {{ htmlspecialchars($value) }}
                                </li>
                                @endforeach
                                <li class="list-group-item">
                                    <strong>Days until Expiry:</strong> {{ (int)$remainingDays }} days
                                </li>
                            </ul>
                            <div class="alert {{ $isExpired ? 'alert-danger' : 'alert-success' }} mt-3">
                                <strong>Status:</strong> {{ $isExpired ? 'Expired' : 'Valid' }}
                            </div>
                            @if ($isExpired)
                            <p class="text-danger mt-2">Your license has expired. Please contact support for assistance with renewing your license.</p>
                            @endif
                        </div>
                        <div class="card-footer">
                            <a href="https://resellercenter.org/" class="btn btn-success"><i class="fas fa-sync"></i> Renew License</a>
                            <a href="{{ url('/panel/license-status') }}" class="btn btn-primary"><i class="fas fa-redo"></i> Refresh License</a>
                        </div>
                    </div>
                </div>

                <!-- Additional Information and Instructions -->
                <div class="col-lg-6 mb-4">
                    <div class="card shadow">
                        <div class="card-header bg-dark text-white">
                            <h3 class="card-title"><i class="fas fa-lightbulb"></i> Additional Information</h3>
                        </div>
                        <div class="card-body">
                            <h5 class="text-muted">License Management Tips:</h5>
                            <ul class="list-unstyled">
                                <li><strong>1. Back Up Your License File:</strong> Always ensure that you back up the `license.key` file.</li>
                                <li><strong>2. Monitor Expiry:</strong> Keep track of the license expiry date to renew in time.</li>
                                <li><strong>3. License Transfer:</strong> Contact support for procedures on transferring licenses.</li>
                                <li><strong>4. Follow Policy:</strong> Adhere to the licensing policy to avoid violations.</li>
                            </ul>
                        </div>
                    </div>
                    <div class="card shadow mt-4">
                        <div class="card-header bg-secondary text-white">
                            <h3 class="card-title"><i class="fas fa-exclamation-circle"></i> Important Instructions</h3>
                        </div>
                        <div class="card-body">
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item">This page is visible only to admin users.</li>
                                <li class="list-group-item">Tampering with the license may result in a ban.</li>
                                <li class="list-group-item">The license file is located at `license.key` in the root directory.</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@section('endfooter')
<!-- Include custom scripts -->
<script>
    // Add any custom interactions or JavaScript logic here if needed.
</script>
@endsection
